// CPPDataWindowPlugIn.h
//
// This file declares an IDataWindowPlugIn implementation.
// The plug-in implements the basic parts of a data window
// in the TLA. It has a data display window and a System
// Window Control.
// 
// The window in this sample does not show any real data.
// The purpose is to demonstrate the basics of how to 
// implement the standard parts of a data window. Any custom
// timing diagrams or data interpretations are left as
// an exercise for the plug-in developer.
/////////////////////////////////////////////////////////////

#pragma once

using namespace System;

namespace CPPDataWindowPlugInSample
{
	// The PlugInIdentity Attribute used below defines the text
	// used in the New Data Window dialog to identify this kind
	// of data window before an instance of it is created.
	[Tektronix::LogicAnalyzer::PlugIn::PlugInIdentity("CPP Sample Data Window")]
	public __gc class CPPDataWindowPlugIn 
	    : public Tektronix::LogicAnalyzer::PlugIn::IDataWindowPlugIn
	{
		// Data members
		DataDisplay* m_display;
		bool m_isValid;
		bool m_isGarbage;
    	String* m_userName;
		SystemWindowUserControl* m_control;

	public:
		// All plug-in must have a default constructor.
		CPPDataWindowPlugIn();

	// IPlugIn members
	    bool Initialize(Tektronix::LogicAnalyzer::TpiNet::ITlaPlugInSupport* support,
	                    bool userInit);
	    __property System::Windows::Forms::Form* get_PrimaryForm() { return m_display; }

	// IValidity members
		virtual __event EventHandler* ValidityChanged;
		
		__property bool get_IsValid() {return m_isValid;}
		__property bool get_IsGarbage() {return m_isGarbage;}

	// IDisposable member
	    void Dispose();

	// IDataWindowPlugIn members

		// Event that is raised when the UserName property changes.
		virtual __event EventHandler* UserNameChanged;

	    // The UserName property sets or gets the name that
		// identifies the data window to users.
		__property String* get_UserName() {return m_userName;}
	    __property void set_UserName(String* value);
	    
		// The value of the SystemWindowControl property is the
		// Control that represents the data window in the
		// TLA System window.
		__property System::Windows::Forms::UserControl* get_SystemWindowControl() 
	        { return m_control; }
		
        // Returns an array of all data sources that are being used
		// by the data window.
        Tektronix::LogicAnalyzer::Common::IDataSource* GetDataSources() [];
        
	    // Event handlers used by this class.
		void OnDisplayClosed(System::Object*, System::EventArgs*);
	    void OnKeyDown(System::Object*, System::Windows::Forms::KeyEventArgs*);
	    void OnLostFocus(System::Object*, System::EventArgs*);
	    void OnActivateDisplay(System::Object*, System::EventArgs*);
	};
}
